using System; 
 using System.Collections.Generic; 
 using System.ComponentModel; using System.Data; 
 using System.Drawing; 
 using System.Linq; 
 using System.Text; using System.Windows.Forms; 
 using PsgBase;
using PsgIntl;

namespace Employees
{
    [EditorClass, ViewGrid]
    public partial class Employees : Base
    {
        #region Members
        EmployeesBE.EmployeesDataTable table = new EmployeesBE.EmployeesDataTable();
        EmployeesBE.EmployeesRow rowA = null;
        #endregion

        #region Constructors

        public Employees()
        {
            InitializeComponent();
        }

        public Employees(ViewGrid _browser):base(_browser)
        {
            InitializeComponent();
        }

        public Employees(LookupGrid _search):base(_search)
        {
            InitializeComponent();
        }

        #endregion constructors

        public override void PsgContext(IContext context)
        {
            base.PsgContext(context);

            context.PsgFieldKey = "employeeid";
            context.PsgFieldDisplay = "lastname";
            context.PsgCommand = "employees";
            context.PsgServerTableName = "employees";
        }

        public override void PsgStart()
        {
            base.PsgStart();
            AddTable("employees", ID, "C");
            GetTables(this);
        }

        public override void PsgBind()
        {
            BindEdit(edLastName, table.LastNameColumn);
            BindEdit(edFirstName, table.FirstNameColumn);
            BindEdit(edTitle, table.TitleColumn);
            BindEdit(edTitleOfCourtesy, table.TitleOfCourtesyColumn);
            BindEdit(edAddress, table.AddressColumn);
            BindEdit(edCity, table.CityColumn);
            BindEdit(edRegion, table.RegionColumn);
            BindEdit(edPostalCode, table.PostalCodeColumn);
            BindEdit(edCountry, table.CountryColumn);
            BindEdit(edHomePhone, table.HomePhoneColumn);
            BindEdit(edNotes, table.NotesColumn);
            BindData(dtBirthDate, table.BirthDateColumn);
            BindData(dtHireDate, table.HireDateColumn);
            base.PsgBind();
        }

        public override void PsgData(DataTable dt)
        {
            base.PsgData(table);
            switch (this.alias_name.ToUpper())
            {
                case "EMPLOYEES":
                    table = (EmployeesBE.EmployeesDataTable)SetMainData(dt, table);
                    rowA = (EmployeesBE.EmployeesRow)table.Rows[0];
                    break;
            }
        }

        public override void PsgView()
        {
            base.PsgView();

            this.ColumnsView(table.LastNameColumn, GetIntl(Intl.Lastname), 100);
            this.ColumnsView(table.FirstNameColumn, GetIntl(Intl.Firstname), 100);
            this.ColumnsView(table.TitleColumn, GetIntl(Intl.Title), 100);
            this.ColumnsView(table.TitleOfCourtesyColumn, GetIntl(Intl.Title_of_courtesy), 150);
            this.ColumnsView(table.BirthDateColumn, GetIntl(Intl.Birthdate));
            this.ColumnsView(table.HireDateColumn, GetIntl(Intl.Hiredate));           
            this.ColumnsView(table.PostalCodeColumn, GetIntl(Intl.Postal_Code));
            this.ColumnsView(table.AddressColumn, GetIntl(Intl.Address), 150);
            this.ColumnsView(table.CityColumn, GetIntl(Intl.City));
            this.ColumnsView(table.RegionColumn, GetIntl(Intl.Region));            
            this.ColumnsView(table.CountryColumn, GetIntl(Intl.Country));
            this.ColumnsView(table.HomePhoneColumn, GetIntl(Intl.Home_phone));
            this.ColumnsView(table.NotesColumn, GetIntl(Intl.Notes), 200);

            this.FiltersView(table.LastNameColumn, GetIntl(Intl.Lastname));
            this.FiltersView(table.FirstNameColumn, GetIntl(Intl.Firstname));
            this.FiltersView(table.TitleColumn, GetIntl(Intl.Title));
            this.FiltersView(table.BirthDateColumn, GetIntl(Intl.Birthdate));
            this.FiltersView(table.HireDateColumn, GetIntl(Intl.Hiredate), "", FilterType.Min);
            this.FiltersView(table.HireDateColumn, GetIntl(Intl.Hiredate), "", FilterType.Max);
            this.FiltersView(table.PostalCodeColumn, GetIntl(Intl.Postal_Code));
            this.FiltersView(table.AddressColumn, GetIntl(Intl.Address));
            this.FiltersView(table.CityColumn, GetIntl(Intl.City));
            this.FiltersView(table.RegionColumn, GetIntl(Intl.Region));
            this.FiltersView(table.CountryColumn, GetIntl(Intl.Country));
            this.FiltersView(table.HomePhoneColumn, GetIntl(Intl.Home_phone));
        }
    }
}